﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static System.Windows.Forms.LinkLabel;
using MySql.Data.MySqlClient;

namespace prj_wfrm_centreCall_tickets
{
    public partial class frmMenu : Form
    {
        public frmMenu()
        {
            InitializeComponent();
        }



        // Gestion des Naf
        private void menuNafAfficherTous_Click(object sender, EventArgs e)
        {
            DataTable resultat = new DataTable();

            string sql = "select NAF_CODE, NAF_INTITULE from tb_naf;";

            resultat = Global.connexion(sql);

            int i = 0;

            foreach (DataRow valeur in resultat.Rows)
            {
                tab.naf[i].code = int.Parse(valeur["NAF_CODE"].ToString());
                tab.naf[i].intitule = valeur["NAF_INTITULE"].ToString();

                //compteur nombre de lignes
                i++;
            }
            tab.nbNaf = i;
            //création de la fenêtre demandée
            frmNafAfficherTous laFenetre = new frmNafAfficherTous();
            //cette nouvelle fenêtre est une fenêtre fille du menu MDI
            laFenetre.MdiParent = this;
            //ouverture de la fenêtre en plein écran
            laFenetre.WindowState = FormWindowState.Maximized;
            laFenetre.Show();
        }

        private void mnuFichierQuitter_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        private void frmMenu_Load(object sender, EventArgs e)
        {

        }

        private void menuCentreAfficherTous_Click_1(object sender, EventArgs e)
        {
            DataTable resultat = new DataTable();

            string sql = "select CNT_NUM, CNT_VILLE from tb_centre;";

            resultat = Global.connexion(sql);

            int i = 0;

            foreach (DataRow valeur in resultat.Rows)
            {
                tab.centre[i].numero = int.Parse(valeur["CNT_NUM"].ToString());
                tab.centre[i].ville = valeur["CNT_VILLE"].ToString();

                //Compteur nombre de lignes
                i++;
            }
            tab.nbCentres = i;
            //création de la fenêtre demandée
            frmCentreAfficherTous laFenetre = new frmCentreAfficherTous();
            //cette nouvelle fenêtre est une fenêtre fille du menu MDI
            laFenetre.MdiParent = this;
            //ouverture de la fenêtre en plein écran
            laFenetre.WindowState = FormWindowState.Maximized;
            laFenetre.Show();
        }

        private void menuTechnicienAfficherTous_Click_1(object sender, EventArgs e)
        {
			//On va récupérer toutes les informations des clients dans notre tableau technicien
			CreerTabTechnicien();
			
			//Lien avec la nouvelle page
			frmTechnicienAfficherTous frmTech = new frmTechnicienAfficherTous();
			frmTech.MdiParent = this;
			//Ouverture de la fenêtre en plein écran
			frmTech.WindowState = FormWindowState.Maximized;
			frmTech.Show();

		}

        private void parTauxHoraireToolStripMenuItem_Click(object sender, EventArgs e)
        {
			//On va récupérer toutes les informations des clients dans notre tableau technicien
			CreerTabTechnicien();

			//Lien avec la nouvelle page
			frmTechnicienAfficherParTauxHoraire frmTechTauxHoraire = new frmTechnicienAfficherParTauxHoraire();
			frmTechTauxHoraire.MdiParent = this;
			//Ouverture de la fenêtre en plein écran
			frmTechTauxHoraire.WindowState = FormWindowState.Maximized;
			frmTechTauxHoraire.Show();
		}

        private void mnuStatistiquesDureeMiniContrat_Click(object sender, EventArgs e)
        {
			//On va récupérer toutes les informations des clients dans notre tableau client
			CreerTabClient();

			//Lien avec la nouvelle page
			frmStatistiquesAfficherDureeMiniContrat frmStatDureeMiniContrat = new frmStatistiquesAfficherDureeMiniContrat();
			frmStatDureeMiniContrat.MdiParent = this;
			//Ouverture de la fenêtre en plein écran
			frmStatDureeMiniContrat.WindowState = FormWindowState.Maximized;
			frmStatDureeMiniContrat.Show();
		}

        private void mnuStatistiquesAfficherNbClientParCodeNaf_Click(object sender, EventArgs e)
        {
			//On va récupérer toutes les informations des clients dans notre tableau client
			CreerTabClient();

			//On va récupérer les informations de la table NAF dans le tableau naf
			DataTable resultat2 = new DataTable();
			string sql2 = "select NAF_CODE, NAF_INTITULE from tb_naf";
			resultat2 = Global.connexion(sql2);

			int j = 0;

            //On rajoute dans le tableau naf les résultats de la requête SQL 
            foreach (DataRow valeur in resultat2.Rows)
			{
				tab.naf[j].code = int.Parse(valeur["NAF_CODE"].ToString());
				tab.naf[j].intitule = valeur["NAF_INTITULE"].ToString();
				//Compteur nombre de lignes
				j++;
			}

            tab.nbNaf = j;

			//Lien avec la nouvelle page
			frmStatistiquesAfficherNbClientParCodeNaf frmStatNbClientParCodeNaf = new frmStatistiquesAfficherNbClientParCodeNaf();
			frmStatNbClientParCodeNaf.MdiParent = this;
			//Ouverture de la fenêtre en plein écran
			frmStatNbClientParCodeNaf.WindowState = FormWindowState.Maximized;
			frmStatNbClientParCodeNaf.Show();
		}

		private void CreerTabTechnicien()
		{
			DataTable resultat = new DataTable();
			string sql = "select TEC_NUM, TEC_NOM, TEC_PRENOM, TEC_TAUX_HORAIRE from tb_technicien;";
			resultat = Global.connexion(sql);

			int i = 0;

            //On rajoute dans le tableau technicien les résultats de la requête SQL 
            foreach (DataRow valeur in resultat.Rows)
			{
				tab.technicien[i].numero = int.Parse(valeur["TEC_NUM"].ToString());
				tab.technicien[i].nomTech = valeur["TEC_NOM"].ToString();
				tab.technicien[i].prenomTech = valeur["TEC_PRENOM"].ToString();
				tab.technicien[i].tauxHoraire = int.Parse(valeur["TEC_TAUX_HORAIRE"].ToString());

				//Compteur nombre de lignes
				i++;
			}
			//Le nombre de techniciens correspond à notre nombre de lignes
			tab.nbTechniciens = i;
		}

		private void CreerTabClient()
		{
			//On va récupérer toutes les informations des clients dans notre tableau client
			DataTable resultat = new DataTable();
			string sql = "select CLN_NUM, CLN_RAISON_SOCIAL, CLN_CNT_NUM, CLN_NAF_CODE, CLN_DATE_CONTRAT, CLN_DUREE_MOIS, CLN_MONTANT_CONTRAT, CLN_MONTANT_TICKET from tb_client";
			resultat = Global.connexion(sql);

			int i = 0;

            //On rajoute dans le tableau client les résultats de la requête SQL 
            foreach (DataRow valeur in resultat.Rows)
			{
				tab.client[i].numero = int.Parse(valeur["CLN_NUM"].ToString());
				tab.client[i].raisonSociale = valeur["CLN_RAISON_SOCIAL"].ToString();
				tab.client[i].centreAppel = valeur["CLN_CNT_NUM"].ToString();
				tab.client[i].intituleNaf = valeur["CLN_NAF_CODE"].ToString();
				tab.client[i].dateContrat = DateTime.Parse(valeur["CLN_DATE_CONTRAT"].ToString());
				tab.client[i].duree = int.Parse(valeur["CLN_DUREE_MOIS"].ToString());
				tab.client[i].montantContrat = Single.Parse(valeur["CLN_MONTANT_CONTRAT"].ToString());
				tab.client[i].montantTickets = Single.Parse(valeur["CLN_MONTANT_TICKET"].ToString());

				//Compteur nombre de lignes
				i++;
			}
			//Le nombre de techniciens correspond à notre nombre de lignes
			tab.nbClients = i;
		}

        private void mnuClientAfficherParCentreAppel_Click_1(object sender, EventArgs e)
        {
			//On va récupérer toutes les informations des clients dans notre tableau client
			DataTable resultat = new DataTable();
			string sql = "select CLN_NUM, CLN_RAISON_SOCIAL, CLN_CNT_NUM, CLN_NAF_CODE, CLN_DATE_CONTRAT, CLN_DUREE_MOIS, CLN_MONTANT_CONTRAT, CLN_MONTANT_TICKET from tb_client";
			resultat = Global.connexion(sql);

			int i = 0;

			foreach (DataRow valeur in resultat.Rows)
			{
				tab.client[i].numero = int.Parse(valeur["CLN_NUM"].ToString());
				tab.client[i].raisonSociale = valeur["CLN_RAISON_SOCIAL"].ToString();
				tab.client[i].centreAppel = valeur["CLN_CNT_NUM"].ToString();
				tab.client[i].intituleNaf = valeur["CLN_NAF_CODE"].ToString();
				tab.client[i].dateContrat = DateTime.Parse(valeur["CLN_DATE_CONTRAT"].ToString());
				tab.client[i].duree = int.Parse(valeur["CLN_DUREE_MOIS"].ToString());
				tab.client[i].montantContrat = Single.Parse(valeur["CLN_MONTANT_CONTRAT"].ToString());
				tab.client[i].montantTickets = Single.Parse(valeur["CLN_MONTANT_TICKET"].ToString());

				//Compteur nombre de lignes
				i++;
			}
			//Le nombre de techniciens correspond à notre nombre de lignes
			tab.nbClients = i;

			frmClientAfficherClientsParCentreAppel frmClientParCentreAppel = new frmClientAfficherClientsParCentreAppel();
			frmClientParCentreAppel.MdiParent = this;
			frmClientParCentreAppel.WindowState = FormWindowState.Maximized;
			frmClientParCentreAppel.Show();
		}
    }
    
}

        
